/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.visitor.DataToTextComponentVisitor;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.attribute.ItemAttributeModifierBase;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.event.IGatherReplacementExclusionEvent;
import com.blamejared.crafttweaker.api.util.AttributeUtil;
import com.blamejared.crafttweaker.natives.entity.ExpandEntity;
import com.blamejared.crafttweaker.natives.entity.ExpandEntityType;
import com.blamejared.crafttweaker.natives.entity.type.player.ExpandPlayer;
import com.blamejared.crafttweaker.natives.world.ExpandLevel;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public interface IEventHelper {
    public static final Map<RecipeType<?>, List<Pair<IIngredient, Integer>>> BURN_TIMES = new HashMap();
    public static final Set<Player> BLOCK_INFO_PLAYERS = new HashSet<Player>();
    public static final Set<Player> ENTITY_INFO_PLAYERS = new HashSet<Player>();
    public static final Map<IIngredient, List<Consumer<ItemAttributeModifierBase>>> ATTRIBUTE_MODIFIERS = new HashMap<IIngredient, List<Consumer<ItemAttributeModifierBase>>>();

    public IGatherReplacementExclusionEvent fireGatherReplacementExclusionEvent(IRecipeManager<?> var1);

    default public void setBurnTime(IIngredient ingredient, int burnTime, RecipeType<?> type) {
        this.getBurnTimes().computeIfAbsent(type, recipeType -> new ArrayList()).add(Pair.of((Object)ingredient, (Object)burnTime));
    }

    public int getBurnTime(IItemStack var1);

    default public Map<RecipeType<?>, List<Pair<IIngredient, Integer>>> getBurnTimes() {
        return BURN_TIMES;
    }

    default public Map<IIngredient, List<Consumer<ItemAttributeModifierBase>>> getAttributeModifiers() {
        return ATTRIBUTE_MODIFIERS;
    }

    default public void applyAttributeModifiers(ItemAttributeModifierBase modifierBase) {
        CompoundTag crtData;
        ItemStack stack = modifierBase.getItemStack();
        if (stack.m_41782_() && (crtData = stack.m_41737_("CraftTweakerData")) != null) {
            AttributeUtil.getAttributeModifiers(stack, modifierBase.getSlotType()).forEach((attribute, modifiers) -> modifiers.forEach(modifier -> {
                if (modifierBase.getModifiers().containsEntry(attribute, modifier)) {
                    modifierBase.removeModifier((Attribute)attribute, (AttributeModifier)modifier);
                }
                modifierBase.addModifier((Attribute)attribute, (AttributeModifier)modifier);
            }));
        }
        Services.EVENT.getAttributeModifiers().keySet().stream().filter(ingredient -> ingredient.matches(Services.PLATFORM.createMCItemStackMutable(stack))).map(Services.EVENT.getAttributeModifiers()::get).flatMap(Collection::stream).forEach(consumer -> consumer.accept(modifierBase));
    }

    default public boolean onBlockInteract(Player player, InteractionHand hand, BlockHitResult hitResult) {
        Level world = player.f_19853_;
        BlockPos pos = hitResult.m_82425_();
        if (BLOCK_INFO_PLAYERS.contains(player)) {
            if (!world.m_5776_() && hand == InteractionHand.MAIN_HAND) {
                MapData tileData;
                BlockState state = world.m_8055_(pos);
                IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.block.name", new Object[]{Services.REGISTRY.getRegistryKey(state.m_60734_())}));
                if (!state.m_61147_().isEmpty()) {
                    IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.block.properties"));
                    state.m_61147_().forEach(property -> IEventHelper.sendAndLog(player, new TextComponent(property.m_61708_()).m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TextComponent(": ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)new TextComponent(state.m_61143_(property).toString()).m_130940_(ChatFormatting.AQUA))));
                }
                if (!(tileData = ExpandLevel.getBlockEntityData(world, pos)).isEmpty()) {
                    IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.block.entity.data", new Object[]{tileData.accept(new DataToTextComponentVisitor("    ", 0))}));
                }
            }
            return true;
        }
        return false;
    }

    default public boolean onEntityInteract(Player player, InteractionHand hand, Entity target) {
        Level world = player.f_19853_;
        if (ENTITY_INFO_PLAYERS.contains(player)) {
            if (!world.m_5776_() && hand == InteractionHand.MAIN_HAND) {
                IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.entity.name", new Object[]{ExpandEntity.getName(target)}));
                IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.entity.type.bracket", new Object[]{ExpandEntityType.getCommandString(target.m_6095_())}));
                MapData data = ExpandEntity.getData(target);
                if (!data.isEmpty()) {
                    IEventHelper.sendAndLog(player, (MutableComponent)new TranslatableComponent("crafttweaker.command.info.entity.data", new Object[]{data.accept(new DataToTextComponentVisitor("    ", 0))}));
                }
            }
            return true;
        }
        return false;
    }

    private static void sendAndLog(Player player, MutableComponent component) {
        ExpandPlayer.sendMessage(player, (Component)component);
        CraftTweakerAPI.LOGGER.info(component.getString());
    }
}

